<?php

$logoPage = new HudsonEdgeAdminPage(
	"1",
	esc_html__( "Logo", 'hudson' ),
	"fa fa-coffee"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"logo",
	$logoPage
);

$panel1 = new HudsonEdgePanel(
	esc_html__( "Logo Upload", 'hudson' ),
	"logo"
);
$logoPage->addChild(
	"panel1",
	$panel1
);

$show_logo = new HudsonEdgeField(
	"yesno",
	"show_logo",
	"yes",
	esc_html__( "Show Logo", 'hudson' ),
	esc_html__( "Disabling this option will hide logo", 'hudson' ),
	array(),
	array(
		"dependence" => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_show_logo_container"
	)
);
$panel1->addChild(
	"show_logo",
	$show_logo
);
$show_logo_container = new HudsonEdgeContainer(
	"show_logo_container",
	"show_logo",
	"no"
);
$panel1->addChild(
	"show_logo_container",
	$show_logo_container
);

$logo_image = new HudsonEdgeField(
	"image",
	"logo_image",
	HUDSON_EDGE_ROOT . "/img/logo.png",
	esc_html__( "Logo Image - Normal", 'hudson' ),
	esc_html__( "Choose a default logo image to display ", 'hudson' )
);
$show_logo_container->addChild(
	"logo_image",
	$logo_image
);

$logo_image_light = new HudsonEdgeField(
	"image",
	"logo_image_light",
	HUDSON_EDGE_ROOT . "/img/logo_white.png",
	esc_html__( "Logo Image - Light", 'hudson' ),
	esc_html__( 'Choose a logo image to display for "Light" header skin', 'hudson' )
);
$show_logo_container->addChild(
	"logo_image_light",
	$logo_image_light
);

$logo_image_dark = new HudsonEdgeField(
	"image",
	"logo_image_dark",
	HUDSON_EDGE_ROOT . "/img/logo_black.png",
	esc_html__( "Logo Image - Dark", 'hudson' ),
	esc_html__( 'Choose a logo image to display for "Dark" header skin', 'hudson' )
);
$show_logo_container->addChild(
	"logo_image_dark",
	$logo_image_dark
);

$logo_image_sticky = new HudsonEdgeField(
	"image",
	"logo_image_sticky",
	HUDSON_EDGE_ROOT . "/img/logo_black.png",
	esc_html__( "Logo Image - Sticky Header", 'hudson' ),
	esc_html__( 'Choose a logo image to display for "Sticky" header type', 'hudson' )
);
$show_logo_container->addChild(
	"logo_image_sticky",
	$logo_image_sticky
);

$logo_image_fixed_hidden = new HudsonEdgeField(
	"image",
	"logo_image_fixed_hidden",
	"",
	esc_html__( "Logo Image - Fixed Advanced Header", 'hudson' ),
	esc_html__( 'Choose a logo image to display for "Fixed Advanced" header type', 'hudson' )
);
$show_logo_container->addChild(
	"logo_image_fixed_hidden",
	$logo_image_fixed_hidden
);

$logo_image_mobile = new HudsonEdgeField(
	"image",
	"logo_image_mobile",
	"",
	esc_html__( "Logo Image - Mobile Header", 'hudson' ),
	esc_html__( 'Choose a logo image to display for "Mobile" header type', 'hudson' )
);
$show_logo_container->addChild(
	"logo_image_mobile",
	$logo_image_mobile
);

$vertical_logo_bottom = new HudsonEdgeField(
	"image",
	"vertical_logo_bottom",
	"",
	esc_html__( "Logo Image - Side Menu Area Bottom", 'hudson' ),
	esc_html__( 'Choose a logo image to display on the bottom of side menu area for "Initially Hidden" side menu area type', 'hudson' )
);
$show_logo_container->addChild(
	"vertical_logo_bottom",
	$vertical_logo_bottom
);

$ribbon_closed_image = new HudsonEdgeField(
	"image",
	"ribbon_closed_image",
	HUDSON_EDGE_ROOT . "/img/logo.png",
	esc_html__( "Logo Image - Ribbon Closed", 'hudson' ),
	esc_html__( "Choose a logo image to display when ribbon header is closed", 'hudson' )
);
$show_logo_container->addChild(
	"ribbon_closed_image",
	$ribbon_closed_image
);

$content_menu_logo_image = new HudsonEdgeField(
	"image",
	"content_menu_logo_image",
	"",
	esc_html__( "Logo Image - Content Menu", 'hudson' ),
	esc_html__( 'Choose a logo image to display on the Content Menu', 'hudson' )
);
$show_logo_container->addChild(
	"content_menu_logo_image",
	$content_menu_logo_image
);